/****************************************************************************/
/*                                                                          */
/* Name      :  HS_ZP3BApi.h                                                */
/* Autor     :  Joerg Heidrich                                              */
/* Inhalt    :  Schnittstellen-Headerdatei der DLL                          */
/*              fr Zhlerkarten ZP088,...                                  */
/*              (Basis-Funktionen)                                          */
/*                                                                          */
/* (c) Heilig & Schwab GmbH                                                 */
/*                                                                          */
/****************************************************************************/
/*                                                                          */
/* Aenderungen                                              Datum    Name   */
/*--------------------------------------------------------------------------*/
/* Originalimplementierung                                  13.08.98    jh  */
/* Gemeinsames Stoppen aller Zhler auf allen Karten        26.06.03    jh  */
/*                                                                          */
/****************************************************************************/

// Statusbits
#define ZP_STOP_STATE_BIT   0x01
#define ZP_ERR_BIT          0x02
#define ZP_REF_BIT          0x04
#define ZP_STOP_BIT         0x08

// Konstanten fr den Referenzmode
#define ZP_NO_REF           0         // Ohne Referenz
#define ZP_ONE_REF          1         // Einfach Referenz
#define ZP_MULTI_REF        2         // Mehrfach Referenz



#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

long FAR PASCAL EXPORT HS_ZP3B_Init(long CardNo);

long FAR PASCAL EXPORT HS_ZP3B_GetVersion(char* DriverVersion,
                                          char* DllVersion);

long FAR PASCAL EXPORT HS_ZP3B_ReadCounter(long CardNo,
                                           long CounterNo,
                                           long *CountVal,
                                           long *CountStat);

long FAR PASCAL EXPORT HS_ZP3B_ReadAllCounter(long CardNo,
                                              long *Count1Val,
                                              long *Count1Stat,
                                              long *Count2Val,
                                              long *Count2Stat,
                                              long *Count3Val,
                                              long *Count3Stat);

long FAR PASCAL EXPORT HS_ZP3B_SetRefMode(long CardNo,
                                          long CounterNo,
                                          long RefMode);

long FAR PASCAL EXPORT HS_ZP3B_StopAllCounter(long CardNo);


#ifdef __cplusplus
}
#endif
